//
//  MCDelegateObject.h
//  MCFoundation
//
//  Created by Eric Hochmeister on 01/09/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//
#import "MCDelegateUser.h"
#import "MCPObjectContext.h"

@protocol MCDelegateObject <NSObject>

- (id)delegateToUser:(id <MCDelegateUser>)toUser fromUser:(id <MCDelegateUser>)fromUser;
- (id)delegateEntryForUser:(id <MCDelegateUser>)aUser;

- (NSArray*)delegates;


// Returns an array built from the set of users in the delegation chain (i.e. no duplicates)
- (NSArray*)delegateUsers;

// Checks if the user wanted to be notified of updates to the delegated object
- (BOOL)delegateUserRequiresNotification:(id <MCDelegateUser>)aUser;

- (void)setDelegateChain:(NSString*)aChain;
- (NSString*)delegateChain;

- (id <MCDelegateUser>)assignedTo;
- (void)setAssignedTo:(id <MCDelegateUser>)aValue;
- (void)setAssignedToID:(NSNumber*)aValue;

- (MCPObjectContext *)objectContext;

- (void)takeStoredValue:aValue forAttribute:(NSString *)anAttribute;

@end
